﻿var longTables = {
    context: $(".v-longTables"),
    datatable: null,
    treeview: null,
    initializeDataTable: function () {
        this.datatable = $(".h-longTables", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetLongTables", "MultiMode", "Settings"),
            columns: [
                { "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true},
                { "Title": resources.Name, "Data": "Name", "HideInSelector": true},
                { "Title": resources.ProjectId, "Data": "ProjectId" },
                { "Title": resources.Project, "Data": "Project" },
                { "Title": resources.CreatedOn, "Data": "CreatedOn", "Type": "date" },
                { "Title": resources.ModifiedOn, "Data": "ModifiedOn", "Type": "date" }
            ],
            stateKey: "LongTables",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete, "Visible": voxco.security.has("DELETE_LT") }
            ],
            contextMenuItems: [
                { "Action": "edit", "Label": resources.EditLongTable },
                { "Divider": true },
                { "Action": "delete", "Label": resources.Delete, "Visible": voxco.security.has("DELETE_LT") },
                { "Action": "properties", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        longTables.deleteLongTables([row.Id]);
                        break;

                    case "edit":
                        modalDialog.showWindow(a4.getAction("LongTableCodes", "MultiMode", "Settings", { id: row.Id, name: row.Name }), 750, 1000, { afterClose: function () { longTables.refreshContent(); } });
                        break;

                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditLongTable", "MultiMode", "Settings", { id: row.Id, name: row.Name, project: row.Project }), 250, 500, { afterClose: function () { longTables.refreshContent(); } });
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    longTables.deleteLongTables(ids);
                }
            },
            localizableTexts: { "Search": resources.SearchLongTables }
        });
    },
    bindEvents: function () {
        $(".h-newLongTableMenu").on("click", "li.h-addLongTable", function () {
            var formatType = $(this).attr("data-format-type");
            modalDialog.showWindow(a4.getAction("EditLongTable", "MultiMode", "settings", { formatType: formatType }), 600, 850,
            {
                beforeClose: function () {
                    var dialogContext = $('.fancybox-iframe').contents();
                    var countErrorRows = parseInt(dialogContext.find(".v-countErrorRows").val(), 10);

                    if (countErrorRows > -1)
                    {
                        if (countErrorRows && countErrorRows > 0)
                            a4.showErrorMessage(resources.LongTableCreationErrors.replace("{0}", countErrorRows));
                        else
                            a4.showSuccessMessage(resources.LongTableCreationSuccess);
                    }
                },
                afterClose: function () {
                    longTables.refreshContent();
                }
            });
        });
    },
    deleteLongTables: function (ids) {
        modalDialog.showConfirmDelete(confirmDeleteLongTablesResources, function () {
            a4.callServerMethod(a4.getAction("DeleteLongTables", "MultiMode", "Settings"), { ids: ids },
                function (result) {
                    longTables.refreshContent();
                });
        }, ids.length);
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    }
}

$(document).ready(function () {
    if (longTables.context.length > 0) {
        longTables.initializeDataTable();
        longTables.bindEvents();
    }
});